/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.architectury.core.RegistryEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class TaskType
extends RegistryEntry<TaskType> {
    public final ResourceLocation id;
    public final Provider provider;
    private final Supplier<Icon> icon;
    private ITextComponent displayName;
    private GuiProvider guiProvider;
    public int intId;

    @Nullable
    public static Task createTask(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        TaskType type = TaskTypes.TYPES.get(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    TaskType(ResourceLocation i, Provider p, Supplier<Icon> ic) {
        this.id = i;
        this.provider = p;
        this.icon = ic;
        this.displayName = null;
        this.guiProvider = new GuiProvider(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Task> callback) {
                Task task = TaskType.this.provider.create(quest);
                if (task instanceof ISingleLongValueTask) {
                    ISingleLongValueTask t = (ISingleLongValueTask)((Object)task);
                    LongConfig c = new LongConfig(0L, t.getMaxConfigValue());
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)t.getDefaultConfigValue(), (Object)t.getDefaultConfigValue(), accepted -> {
                        if (accepted) {
                            ((ISingleLongValueTask)((Object)task)).setValue((Long)c.value);
                            callback.accept(task);
                        }
                        gui.run();
                    });
                    return;
                }
                ConfigGroup group = new ConfigGroup("ftbquests");
                task.getConfig(task.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(task);
                    }
                    gui.run();
                };
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.id.func_110624_b().equals("ftbquests") ? this.id.func_110623_a() : this.id.toString();
    }

    public TaskType setDisplayName(ITextComponent name) {
        this.displayName = name;
        return this;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent("ftbquests.task." + this.id.func_110624_b() + '.' + this.id.func_110623_a());
        }
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.get();
    }

    public TaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Task> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public Task create(Quest var1);
    }
}

